--------------------------------------------------------------------------------------
-- Script KUJU 
--------------------------------------------------------------------------------------
-- INITIALISE
--

function Initialise ( )
	
	DefaultInitialise()
	
	gInitialised = false
	gAnimState = -1
	gArmState = -1	
	
	gSignalState = SIGNAL_VOIELIBRE
	
	Call( "BeginUpdate" )
end
--------------------------------------------------------------------------------------
-- DEFAULT INITIALISE
--

function DefaultInitialise()

	gLinkCount = Call( "GetLinkCount" )
	
	gOccupationTable = {}
	for i=0, gLinkCount - 1 do
		gOccupationTable[i] = 0
	end

	gLinkState = {}
	for link = 0, gLinkCount - 1 do
		gLinkState[link] = SIGNAL_VOIELIBRE
	end
end

--------------------------------------------------------------------------------------
-- UPDATE
--

function Update( time )

	gInitialised = true
	
	if gLinkCount > 1 then
		OnJunctionStateChange( 0, "", 1, 0 )
	end

	if (gAnimState == "Clear01") then
		
		Call("Main Home Arm:Reset","Stop01")
		
		if Call("Main Home Arm:AddTime","Clear01", time ) ~= 0 then
			gArmState = AILE_OUVERTE
			Call( "EndUpdate" )
		end
		
	elseif (gAnimState == "Stop01") then
		
		Call("Main Home Arm:Reset", "Clear01")
		
		if Call( "Main Home Arm:AddTime","Stop01", time ) ~= 0 then
			gArmState = AILE_FERMEE
			Call( "EndUpdate" )
		end
		
	elseif gSignalState == SIGNAL_VOIELIBRE then
		SetState(SIGNAL_VOIELIBRE)

	else
		Call( "EndUpdate" )		
	
	end	
end
--------------------------------------------------------------------------------------
-- RESET SIGNAL STATE
--
function ResetSignalState ( )
	
	Initialise()
	
end
--------------------------------------------------------------------------------------
-- GLOBALS

CLEAR = 0
WARNING = 1
BLOCKED = 2

RESET_SIGNAL_STATE					= 0
INITIALISE_SIGNAL_TO_BLOCKED 		= 1
JUNCTION_STATE_CHANGE				= 2
INITIALISE_TO_PREPARED				= 3

OCCUPATION_INCREMENT				= 10
OCCUPATION_DECREMENT				= 11

OUVERT								= 12
FERME								= 13

SIGNAL_CARRE						= 14
SIGNAL_VOIELIBRE					= 15
SIGNAL_AVERTISSEMENT				= 16
SIGNAL_JAUNEcli						= 17
SIGNAL_ROUGEcli						= 18
SIGNAL_SEMAPHORE                    = 19
SIGNAL_VERTcli	                    = 20
SIGNAL_R30                          = 21
SIGNAL_R60                          = 22
SIGNAL_R60JAUNEcli                  = 23
SIGNAL_RR30                         = 24
SIGNAL_RR60                         = 25
SIGNAL_RR30AVERTISSEMENT            = 26
SIGNAL_RR30JAUNEcli                 = 27
SIGNAL_RR60AVERTISSEMENT            = 28
SIGNAL_RR60JAUNEcli                 = 29
SIGNAL_AVERTISSEMENTBJ              = 30
SIGNAL_ARR30BJ						= 31
SIGNAL_DISQUE						= 32
SIGNAL_MANOEUVRE					= 33
SIGNAL_BLANCcli						= 34
SIGNAL_ETEINT						= 35
SIGNAL_GASAM						= 36

SIGNAL_MESSAGE1						= 37
SIGNAL_MESSAGE2						= 38
SIGNAL_MESSAGE3						= 39
SIGNAL_MESSAGE4						= 40
SIGNAL_MESSAGE5						= 41

PN1_Arrive							= 42
PN1_Depart							= 43
PN2_Arrive							= 44
PN2_Depart							= 45
PN3_Arrive							= 46
PN3_Depart							= 47
TIV_Ouvert							= 48
TIV_Ferme							= 49

PASS_OFFSET							= 50

PASS_RESET_SIGNAL_STATE				= PASS_OFFSET + RESET_SIGNAL_STATE	-- Never used!
PASS_JUNCTION_STATE_CHANGE			= PASS_OFFSET + JUNCTION_STATE_CHANGE
PASS_INITIALISE_SIGNAL_TO_BLOCKED 	= PASS_OFFSET + INITIALISE_SIGNAL_TO_BLOCKED 
PASS_INITIALISE_TO_PREPARED 		= PASS_OFFSET + INITIALISE_TO_PREPARED
PASS_OCCUPATION_INCREMENT			= PASS_OFFSET + OCCUPATION_INCREMENT
PASS_OCCUPATION_DECREMENT			= PASS_OFFSET + OCCUPATION_DECREMENT
PASS_SIGNAL_CARRE					= PASS_OFFSET + SIGNAL_CARRE
PASS_SIGNAL_VOIELIBRE				= PASS_OFFSET + SIGNAL_VOIELIBRE
PASS_SIGNAL_AVERTISSEMENT			= PASS_OFFSET + SIGNAL_AVERTISSEMENT
PASS_SIGNAL_JAUNEcli				= PASS_OFFSET + SIGNAL_JAUNEcli
PASS_SIGNAL_ROUGEcli				= PASS_OFFSET + SIGNAL_ROUGEcli		
PASS_SIGNAL_SEMAPHORE				= PASS_OFFSET + SIGNAL_SEMAPHORE
PASS_SIGNAL_VERTcli					= PASS_OFFSET + SIGNAL_VERTcli
PASS_SIGNAL_R30   					= PASS_OFFSET + SIGNAL_R30
PASS_SIGNAL_R60    					= PASS_OFFSET + SIGNAL_R60
PASS_SIGNAL_R60JAUNEcli				= PASS_OFFSET + SIGNAL_R60JAUNEcli
PASS_SIGNAL_RR30      				= PASS_OFFSET + SIGNAL_RR30
PASS_SIGNAL_RR60      				= PASS_OFFSET + SIGNAL_RR60
PASS_SIGNAL_RR30AVERTISSEMENT     	= PASS_OFFSET + SIGNAL_RR30AVERTISSEMENT
PASS_SIGNAL_RR30JAUNEcli			= PASS_OFFSET + SIGNAL_RR30JAUNEcli
PASS_SIGNAL_RR60AVERTISSEMENT		= PASS_OFFSET + SIGNAL_RR60AVERTISSEMENT
PASS_SIGNAL_RR60JAUNEcli			= PASS_OFFSET + SIGNAL_RR60JAUNEcli
PASS_SIGNAL_AVERTISSEMENTBJ			= PASS_OFFSET + SIGNAL_AVERTISSEMENTBJ
PASS_SIGNAL_ARR30BJ					= PASS_OFFSET + SIGNAL_ARR30BJ
PASS_SIGNAL_DISQUE					= PASS_OFFSET + SIGNAL_DISQUE
PASS_SIGNAL_MANOEUVRE				= PASS_OFFSET + SIGNAL_MANOEUVRE
PASS_SIGNAL_BLANCcli				= PASS_OFFSET + SIGNAL_BLANCcli
PASS_SIGNAL_ETEINT					= PASS_OFFSET + SIGNAL_ETEINT
PASS_SIGNAL_GASAM					= PASS_OFFSET + SIGNAL_GASAM

gConnectedLink = 0
gUpdating = 0

AWS_MESSAGE								= 11
TPWS_MESSAGE							= 12
SPAD_MESSAGE							= 14
CROCO_MESSAGE 							= 13

AILE_OUVERTE 	= 1
AILE_FERMEE		= 2
-- debugging stuff
DEBUG = false 									-- set to true to turn debugging on
function DebugPrint( message )
	if (DEBUG) then
		Print( message )
	end
   end
--------------------------------------------------------------------------------------
-- JUNCTION STATE CHANGE
---

function OnJunctionStateChange( junction_state, parameter, direction, linkIndex )

	if junction_state == 0 then
		if linkIndex == 0 then
			if gLinkCount == 1 then

			else

				linkCountAsString = "" .. (5 * (gLinkCount + 1))
				
				local newConnectedLink = Call( "GetConnectedLink", linkCountAsString, 1, 0 )
				
				if newConnectedLink == gConnectedLink then

				else
				
					gConnectedLink = newConnectedLink
					
					if gConnectedLink > 0 then
						
						if (gOccupationTable[gConnectedLink] == 0) and (gOccupationTable[0] == 0) then							

							CheckSignalState( )
							
						else
						
							Carre( gConnectedLink )
							
						end
						
					elseif gConnectedLink == -1 then
					
						Carre( 0 )
						Call( "SendSignalMessage", SIGNAL_CARRE, "", -1, 1, 0 )						
						
					end
				end
			end
		end
	end
end

--------------------------------------------------------------------------------------
-- ON CONSIST PASS
--
function OnConsistPass ( prevFrontDist, prevBackDist, frontDist, backDist, linkIndex )

	local crossingStart = 0
	local crossingEnd = 0

	if ( frontDist > 0 and backDist < 0 ) or ( frontDist < 0 and backDist > 0 ) then

		if ( prevFrontDist < 0 and prevBackDist < 0 ) or ( prevFrontDist > 0 and prevBackDist > 0 ) then

			crossingStart = 1
		end
		
	else	

		if ( prevFrontDist < 0 and prevBackDist > 0 ) or ( prevFrontDist > 0 and prevBackDist < 0 ) then

			crossingEnd = 1
		end
	end

	if (crossingStart == 1) then
		
		--------------------------------------------------------------------------------------
		if (prevFrontDist > 0 and prevBackDist > 0) then
			
			if (linkIndex == 0) then
			
				if (gSignalState == SIGNAL_CARRE) then
                                         DebugPrint("SPAD")
					Call( "SendConsistMessage", SPAD_MESSAGE, "" )
					
				end

				Carre( 0 )
				
				gOccupationTable[0] = gOccupationTable[0] + 1
				
			elseif (linkIndex > 0) then
			
				gOccupationTable[linkIndex] = gOccupationTable[linkIndex] + 1

			end
			
		--------------------------------------------------------------------------------------
		elseif (prevFrontDist < 0 and prevBackDist < 0) then
			

			if (linkIndex == 0) then

				if gOccupationTable[0] == 1 and gConnectedLink ~= -1 then

					local signalStateMessage = gLinkState[gConnectedLink]

					Call( "SendSignalMessage", signalStateMessage, "", -1,1, 0 )
				end

				Call( "SendSignalMessage", OCCUPATION_INCREMENT, "", -1, 1, 0 )
				
			elseif (linkIndex > 0) then

				if (gConnectedLink == linkIndex) then
				
					gOccupationTable[0] = gOccupationTable[0] + 1

				else

				end
			end
		end
		
	elseif (crossingEnd == 1) then
		
		--------------------------------------------------------------------------------------
		if (frontDist > 0 and backDist > 0) then
			
			if (linkIndex == 0) then
				if gOccupationTable[0] > 0 then
				
					gOccupationTable[0] = gOccupationTable[0] - 1

				else

				end
				
				if (gOccupationTable[0] == 0 and gConnectedLink ~= -1 and gOccupationTable[gConnectedLink] == 0) then
				
					CheckSignalState( )
				end

			elseif (linkIndex > 0) then
				if gOccupationTable[linkIndex] > 0 then
				
					gOccupationTable[linkIndex] = gOccupationTable[linkIndex] - 1

				else

				end
			end
			
		--------------------------------------------------------------------------------------
		elseif (frontDist < 0 and backDist < 0) then
			
			if (linkIndex == 0) then

				Call( "SendSignalMessage", SIGNAL_CARRE, "", -1, 1, 0 )
				Call( "SendSignalMessage", OCCUPATION_DECREMENT, "", -1, 1, 0 )			
				
			elseif (linkIndex > 0) then

				if (gConnectedLink == linkIndex) then

				if gOccupationTable[0] > 0 then
				
						gOccupationTable[0] = gOccupationTable[0] - 1

					else

					end
				else

				end
			end
		end
	end
end
--------------------------------------------------------------------------------------
-- NONOCCUPE
--
function NonOccupe( linkIndex )

	if (linkIndex == 0 and gConnectedLink > 0) then
	
		linkIndex = gConnectedLink
	end

	if (gConnectedLink == linkIndex) then
	
		if (gOccupationTable[linkIndex] ~= nil) and 
			(gOccupationTable[linkIndex] == 0) and
			(gOccupationTable[0] == 0) then
	
			if gSignalState ~= SIGNAL_VOIELIBRE then
			
				SetState( SIGNAL_VOIELIBRE )
				Call( "SendSignalMessage", SIGNAL_VOIELIBRE, "", -1, 1, 0 )
			end
		end
	end
	
	gLinkState[linkIndex] = SIGNAL_VOIELIBRE
end
--------------------------------------------------------------------------------------
-- CARRE
--
function Carre( linkIndex )

	if gSignalState ~= SIGNAL_CARRE then
	
		SetState( SIGNAL_CARRE )
	end

end
--------------------------------------------------------------------------------------
-- ON SIGNAL MESSAGE
--

function OnSignalMessage( message, parameter, direction, linkIndex )

	if (linkIndex > 0) then
	
		if message > PASS_OFFSET then
			Call( "SendSignalMessage", message, parameter, -direction, 1, linkIndex )
			
		elseif message ~= RESET_SIGNAL_STATE and message ~= JUNCTION_STATE_CHANGE and parameter ~= "DoNotForward" then
			Call( "SendSignalMessage", message + PASS_OFFSET, parameter, -direction, 1, linkIndex )
		end
	end
	
	if (linkIndex >= 0) then

		if message >= PASS_INITIALISE_SIGNAL_TO_BLOCKED then

			if linkIndex > 0 then

				ReactToSignalMessage( message - PASS_OFFSET, parameter, direction, linkIndex )
			end

		else
			ReactToSignalMessage( message, parameter, direction, linkIndex )		
		end
	end
end
-------------------------------------------------------------------------------------
-- SET STATE
--
function SetState( newState )
	
    if (newState == SIGNAL_VOIELIBRE) then

		Call ("Set2DMapSignalState", CLEAR)
		if gArmState ~= AILE_OUVERTE then
			gAnimState = "Clear01"
			Call("BeginUpdate")
		end

    elseif (newState == SIGNAL_CARRE) then

		Call ("Set2DMapSignalState", BLOCKED)
		if gArmState ~= AILE_FERMEE then
			gAnimState = "Stop01"
			Call("BeginUpdate")
		end
	end

gSignalState = newState

end
--------------------------------------------------------------------------------------
-- GET SIGNAL STATE
--
function GetSignalState( )

	local signalState = -1

	if (gSignalState == SIGNAL_VOIELIBRE) then
	
		signalState = CLEAR
		
	elseif (gSignalState == SIGNAL_CARRE) then
	
		signalState = BLOCKED

	else

	end
	
	return signalState

end
--------------------------------------------------------------------------------------
-- CHECK SIGNAL STATE
--
function CheckSignalState( )

	if gConnectedLink < 0 then
	
	elseif gLinkState[gConnectedLink] == SIGNAL_VOIELIBRE then
	
		NonOccupe( gConnectedLink )

	else

	end
end	
-------------------------------------------------------------------------------------
-- REACT TO SIGNAL MESSAGE

function ReactToSignalMessage( message, parameter, direction, linkIndex )
			
	if (message == RESET_SIGNAL_STATE) then
	
			ResetSignalState()

	elseif (message == INITIALISE_SIGNAL_TO_BLOCKED) then
	
		gOccupationTable[linkIndex] = gOccupationTable[linkIndex] + 1
		
		if (gLinkCount == 1) then
		
			Carre( 0 )
			Call( "SendSignalMessage", SIGNAL_CARRE, "", -1, 1, 0 )						
		end									

	elseif (direction == 1) then
			
		if ( message == SIGNAL_AVERTISSEMENT
			or message == SIGNAL_VOIELIBRE
			or message == SIGNAL_R30 ) then
			NonOccupe( linkIndex )
		
		elseif (message == OCCUPATION_DECREMENT) then

			if gOccupationTable[linkIndex] > 0 then
		
				gOccupationTable[linkIndex] = gOccupationTable[linkIndex] - 1

			else

			end

			NonOccupe( linkIndex )

		elseif (message == OCCUPATION_INCREMENT) then

			gOccupationTable[linkIndex] = gOccupationTable[linkIndex] + 1

			if (gConnectedLink == linkIndex) then
		
				Carre( linkIndex )
				Call( "SendSignalMessage", SIGNAL_CARRE, "", -1, 1, 0 )				
				
			end

		elseif (message == JUNCTION_STATE_CHANGE) then

			if gInitialised and linkIndex == 0 and parameter == "0" and gLinkCount > 1 then
		
				OnJunctionStateChange( 0, "", 1, 0 )
			
				Call( "SendSignalMessage", message, parameter, -direction, 1, linkIndex )
			end
			
		else
		
			Call( "SendSignalMessage", message, parameter, -1, 1, 0 )			

		end
		
	elseif (direction == -1) then	
		
		Call( "SendSignalMessage", message, parameter, 1, 1, linkIndex )
		
	end	
		
end




